/*
 * Decompiled with CFR 0.152.
 */
package dinesh.mobile.sms.ringtone;

import dinesh.io.BitInputStream;
import dinesh.io.BitOutputStream;
import dinesh.mobile.sms.ringtone.Constants;
import dinesh.mobile.sms.ringtone.PatternInstruction;
import java.io.IOException;

public class SongPattern
implements Constants {
    private int headerID;
    private int id;
    private int loop;
    private int specifier;
    private PatternInstruction[] instruction;

    public SongPattern(BitInputStream bitInputStream) throws IOException {
        this.headerID = bitInputStream.read(3);
        this.id = bitInputStream.read(2);
        this.loop = bitInputStream.read(4);
        this.specifier = bitInputStream.read();
        this.instruction = new PatternInstruction[this.specifier];
        for (int i = 0; i < this.specifier; ++i) {
            this.instruction[i] = PatternInstruction.build(bitInputStream);
        }
    }

    public SongPattern(PatternInstruction[] patternInstructionArray) {
        this.instruction = patternInstructionArray;
        this.specifier = patternInstructionArray.length;
        this.loop = 0;
        this.id = 0;
        this.headerID = 0;
    }

    public void writeToStream(BitOutputStream bitOutputStream) throws Exception {
        bitOutputStream.write(this.headerID, 3);
        bitOutputStream.write(this.id, 2);
        bitOutputStream.write(this.loop, 4);
        bitOutputStream.write(this.specifier);
        if (this.instruction != null) {
            for (int i = 0; i < this.instruction.length; ++i) {
                this.instruction[i].writeToStream(bitOutputStream);
            }
        }
    }

    public int length() {
        int n = 17;
        if (this.instruction != null) {
            for (int i = 0; i < this.instruction.length; ++i) {
                n += this.instruction[i].length();
            }
        }
        return n;
    }

    public int getHeaderID() {
        return this.headerID;
    }

    public int getID() {
        return this.id;
    }

    public int getLoop() {
        return this.loop;
    }

    public int getSpecifier() {
        return this.specifier;
    }

    public int getPatternInstructionLength() {
        return this.instruction.length;
    }

    public PatternInstruction getPatternInstruction(int n) {
        return this.instruction[n];
    }
}

